#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cassert>

#include <iostream>
#include <iomanip>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <deque>
#include <queue>
#include <stack>


#define forn(i, n) for(int i = 0; i < int(n); i++)
#define mp make_pair
#define pb push_back
#define foreach(it, v) for(__typeof(v.begin()) it = v.begin(); it != v.end(); ++it)

using namespace std;

typedef long long ll;

const int kMaxN = 16;
const int kMaxValue = 3600;

int n, targetValue;
int buttons[kMaxN + 1];
int d[kMaxValue + 1];
queue < int > q;

void solveOne() {
	scanf("%d%d", &n, &targetValue);
	for(int i = 0; i < n; i++)
		scanf("%d", &buttons[i]);
	//buttons[n] = 1;
	//++n;
	memset(d, -1, sizeof(d));
	d[0] = 0;
	q.push(0);
	while(!q.empty()) {
		int u = q.front();
		q.pop();
		for(int i = 0; i < n; i++) {
			int newValue = u + buttons[i];
			if(newValue < 0) newValue = 0;
			if(newValue > kMaxValue) newValue = kMaxValue;
			if(d[newValue] == -1) {
				d[newValue] = d[u] + 1;
				q.push(newValue);
			}
		}
	}
	int result = targetValue;
	while(d[result] == -1) {
		++result;
		assert(result <= kMaxValue);
	}
	printf("%d %d\n", d[result], result - targetValue);
}

int main() {
	int tests;
	scanf("%d", &tests);
	for(int i = 0; i < tests; i++)
		solveOne();
	return 0;
}